<x-kasir.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:head>

        <link rel="stylesheet"
            href="{{ asset('assets/admin/') }}/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
        <link rel="stylesheet" href="{{ asset('assets/admin/') }}/plugins/daterangepicker/daterangepicker.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('assets/admin/') }}/plugins/summernote/summernote-bs4.min.css">
        <style>
            .btn_menu {
                height: 150px;
            }

            .btn_menu i {
                margin-top: 30px;
            }
        </style>
    </x-slot:head>


    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">

            </div><!-- /.container-fluid -->
        </div>

        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="row">

                            <div class="col-md-3 mb-3">
                                <a href="/transaksi" class="btn  btn-danger btn_menu btn-block ">
                                    <i class="fa fa-cart-plus fa-3x"></i>
                                    <div class="mt-2">
                                        Transaksi
                                    </div>
                                </a>
                            </div>



                            <div class="col-md-3 mb-3">
                                <a href="/order-online" class="btn btn-success btn_menu btn-block">
                                    <i class="fa fa-shopping-basket fa-3x"></i>
                                    <div class="mt-2">
                                        Order Online
                                    </div>
                                </a>
                            </div>

                            <div class="col-md-3 mb-3">
                                <a href="/member" class="btn btn-primary btn_menu btn-block">
                                    <i class="fa fa-users fa-3x"></i>
                                    <div class="mt-2">
                                        Member
                                    </div>
                                </a>
                            </div>

                            <div class="col-md-3 mb-3">
                                <a href="/stok" class="btn btn-warning btn_menu btn-block">
                                    <i class="fa fa-cubes fa-3x"></i>
                                    <div class="mt-2">
                                        Stok Masuk
                                    </div>
                                </a>
                            </div>


                            {{-- <div class="col-md-3 mb-3">
                                <a href="/antaran" class="btn btn-warning btn_menu btn-block">
                                    <i class="fa fa-truck fa-3x"></i>
                                    <div class="mt-2">
                                        Status Antaran
                                    </div>
                                </a>
                            </div> --}}

                            <div class="col-md-6 mb-3">
                                <a href="/tukar-poin" class="btn btn-secondary btn_menu btn-block">
                                    <i class="fa fa-shopping-bag fa-3x"></i>
                                    <div class="mt-2">
                                        Tukar Poin
                                    </div>
                                </a>
                            </div>

                            <div class="col-md-6 mb-3">
                                <a href="/laporan-invoice" class="btn btn-info btn_menu btn-block">
                                    <i class="fa fa-print fa-3x"></i>
                                    <div class="mt-2">
                                        Laporan Invoice
                                    </div>
                                </a>
                            </div>

                            <div class="col-md-12 ">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">
                                            <i class="fa fa-user-circle mr-1"></i>
                                            Pendaftaran member baru
                                        </h3>

                                    </div>
                                    <div class="card-body">
                                        <table class="table table-bordered table-striped tab ">
                                            <thead>
                                                <tr>
                                                    <th style="width: 6%;">No</th>
                                                    <th>Kode Member</th>
                                                    <th>Atas Nama</th>
                                                    <th>Tgl. Daftar</th>
                                                    <th>Jns. Kelamin </th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="view">
                                                @forelse ($member as $m)
                                                    <tr>
                                                        <td class="text-center">{{ $no++ }}</td>
                                                        <td>{{ $m->member->kd_member }}</td>
                                                        <td>{{ $m->member->nm_member }}</td>
                                                        <td>{{ tgl_inf($m->member->created_at) }}</td>
                                                        <td>{{ $m->member->kelamin_member == 'L' ? 'Laki-Laki' : 'Perempuan' }}
                                                        </td>
                                                        <td class="text-center">
                                                            <button class="btn btn-dark  verifikasi"
                                                                data-id="{{ $m->member->id }}"> <i
                                                                    class="fa fa-hand-pointer mr-2"></i> Menunggu di
                                                                Verifikasi</button>
                                                        </td>

                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="6" class="text-center"></td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    <!-- /.col-md-6 -->
                    <div class="col-lg-4">

                        <div class="card card-widget widget-user">
                            <!-- Add the bg color to the header using any of the bg-* classes -->
                            <div class="widget-user-header bg-primary">
                                <h3 class="widget-user-username">{{ Auth::user()->nm_user }}</h3>
                                <h5 class="widget-user-desc">User Kasir</h5>
                            </div>
                            <div class="widget-user-image">
                                <img class="img-circle elevation-2"
                                    src="{{ asset('assets/admin/') }}/dist/img/avatar.png" alt="User Avatar">
                            </div>
                            <div class="card-footer">
                                <div class="row">
                                    <div class="col-sm-4 border-right">
                                        <div class="description-block">
                                            <h5 class="description-header">{{ $data['tottran'] }}</h5>
                                            <span class="description-text">TRANSAKSI</span>
                                        </div>
                                        <!-- /.description-block -->
                                    </div>
                                    <!-- /.col -->
                                    <div class="col-sm-4 border-right">
                                        <div class="description-block">
                                            <h5 class="description-header">{{ $data['ttlitem'] }}</h5>
                                            <span class="description-text">PRODUK</span>
                                        </div>
                                        <!-- /.description-block -->
                                    </div>
                                    <!-- /.col -->
                                    <div class="col-sm-4">
                                        <div class="description-block">
                                            <h5 class="description-header">{{ $data['jmltotal'] }}</h5>
                                            <span class="description-text">TOTAL</span>
                                        </div>
                                        <!-- /.description-block -->
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                            </div>
                        </div>


                        <div class="card bg-gradient-dark">
                            <div class="card-header border-0">

                                <h3 class="card-title">
                                    <i class="far fa-calendar-alt"></i>
                                    Calendar
                                </h3>
                                <!-- tools card -->

                                <!-- /. tools -->
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body pt-0">
                                <!--The calendar -->
                                <div id="calendar" style="width: 100%"></div>
                            </div>
                            <!-- /.card-body -->
                        </div>


                    </div>
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
    </div>
    <!-- /.content -->

    {{-- Edit Ongkir --}}
    <div class="modal fade" id="editongkir">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Verifikasi member
                </div>
                <div class="modal-body" id="vdataongkir">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <x-slot:foot>

        <script src="{{ asset('assets/admin/') }}/plugins/moment/moment.min.js"></script>
        <script src="{{ asset('assets/admin/') }}/plugins/daterangepicker/daterangepicker.js"></script>
        <script src="{{ asset('assets/admin/') }}/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js">
        </script>
        <script src="{{ asset('assets/admin/') }}/plugins/summernote/summernote-bs4.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $(function() {

                $('#calendar').datetimepicker({
                    format: 'L',
                    inline: true
                });

                $('#view').on('click', '.verifikasi', function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var id = $(this).attr("data-id");
                    var baru = 'baru';
                    $.ajax({
                        type: "POST",
                        url: "/view-edit-ongkir",
                        data: {
                            id: id,
                            baru: baru,
                            _token: token,
                        },
                        success: function(data) {
                            $("#editongkir").modal("show");
                            $("#vdataongkir").html(data);
                        },
                    });
                });

                $("#vdataongkir").on("change", ".cariongkir", function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var id = $(this).val();
                    $.ajax({
                        type: "POST",
                        url: "/view-ongkir",
                        dataType: "JSON",
                        data: {
                            id: id,
                            _token: token,
                        },
                        success: function(data) {
                            $("#rute").val(data.alamat);
                            $("#berat").val(data.berat);
                            $("#harga").val(data.harga);
                        },
                    });
                });

                $("#vdataongkir").on("click", ".terapkan", function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var id = $(this).attr("data-id");
                    var alamat = $("#alamat").val();
                    var sts_alamat = $("#sts_alamat").val();
                    var ido = $("#ongkir").val();
                    $.ajax({
                        type: "POST",
                        url: "update-ongkir-member",
                        data: {
                            id: id,
                            ido: ido,
                            alamat: alamat,
                            sts_alamat: sts_alamat,
                            _token: token,
                        },
                        beforeSend: function() {
                            $(this).html(
                                '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                            );
                            $(this).attr("disabled", true);
                        },
                        success: function(data) {
                            $(this).html(' <i class="fa fa-check mr-2"></i> Terapkan');
                            $(this).attr("disabled", false);
                            Swal.fire({
                                icon: "success",
                                title: "Berhasil",
                                text: "Member berhasil diverifikasi!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    document.location.href = "";
                                }
                            });
                        },
                    });
                });
            })
        </script>

        <script></script>
    </x-slot:foot>
</x-kasir.contents>
